# arr-swap [![NPM version](https://img.shields.io/npm/v/arr-swap.svg?style=flat)](https://www.npmjs.com/package/arr-swap) [![NPM monthly downloads](https://img.shields.io/npm/dm/arr-swap.svg?style=flat)](https://npmjs.org/package/arr-swap) [![NPM total downloads](https://img.shields.io/npm/dt/arr-swap.svg?style=flat)](https://npmjs.org/package/arr-swap) [![Linux Build Status](https://img.shields.io/travis/jonschlinkert/arr-swap.svg?style=flat&label=Travis)](https://travis-ci.org/jonschlinkert/arr-swap)

> Swap two items in an array. Does not modify the Array prototype.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save arr-swap
```

## Usage

```js
var swap = require('arr-swap');
```

**By index**

Swap by array index:

```js
var arr = ['a', 'b', 'c'];
console.log(swap(arr, 0, 1));
//=> ['b', 'a', 'c'];
```

**By element**

Swap by array elements:

```js
var arr = ['a', 'b', 'c'];
console.log(swap(arr, 'a', 'b'));
//=> ['b', 'a', 'c'];
```

## About

### Related projects

* [arr-flatten](https://www.npmjs.com/package/arr-flatten): Recursively flatten an array or arrays. | [homepage](https://github.com/jonschlinkert/arr-flatten "Recursively flatten an array or arrays.")
* [arr-union](https://www.npmjs.com/package/arr-union): Combines a list of arrays, returning a single array with unique values, using strict equality… [more](https://github.com/jonschlinkert/arr-union) | [homepage](https://github.com/jonschlinkert/arr-union "Combines a list of arrays, returning a single array with unique values, using strict equality for comparisons.")
* [array-unique](https://www.npmjs.com/package/array-unique): Remove duplicate values from an array. Fastest ES5 implementation. | [homepage](https://github.com/jonschlinkert/array-unique "Remove duplicate values from an array. Fastest ES5 implementation.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

Please read the [contributing guide](.github/contributing.md) for advice on opening issues, pull requests, and coding standards.

### Building docs

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

### Running tests

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](https://twitter.com/jonschlinkert)

### License

Copyright © 2017, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.6.0, on May 25, 2017._